/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.behaviour;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.Vector2;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import technology.rocketjump.undermount.assets.entities.item.model.ItemPlacement;
import technology.rocketjump.undermount.entities.components.BehaviourComponent;
import technology.rocketjump.undermount.entities.components.SteeringComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.LocationComponent;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.jobs.model.JobType;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.rooms.ItemAllocation;
import technology.rocketjump.undermount.rooms.Room;

public class ItemBehaviour
implements BehaviourComponent {
    private LocationComponent locationComponent;
    private MessageDispatcher messageDispatcher;
    private Entity parentEntity;

    @Override
    public void init(Entity parentEntity, MessageDispatcher messageDispatcher, TiledMap areaMap) {
        this.locationComponent = parentEntity.getLocationComponent();
        this.messageDispatcher = messageDispatcher;
        this.parentEntity = parentEntity;
    }

    @Override
    public ItemBehaviour clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        ItemBehaviour cloned = new ItemBehaviour();
        cloned.init(this.parentEntity, messageDispatcher, tiledMap);
        return cloned;
    }

    @Override
    public void update(float deltaTime, TiledMap areaMap) {
    }

    @Override
    public void infrequentUpdate(GameContext gameContext) {
        ItemEntityAttributes attributes = (ItemEntityAttributes)this.parentEntity.getPhysicalEntityComponent().getAttributes();
        if (this.locationComponent.getWorldPosition() != null && attributes.getItemPlacement().equals((Object)ItemPlacement.ON_GROUND) && attributes.getNumUnallocated() > 0) {
            ItemAllocation haulingAllocation;
            Room room;
            MapTile tile = gameContext.getAreaMap().getTile(this.locationComponent.getWorldPosition());
            boolean inStockpile = false;
            if (tile.getRoomTile() != null && (room = tile.getRoomTile().getRoom()).getRoomType().isStockpileComponent()) {
                inStockpile = true;
            }
            if (!inStockpile && (haulingAllocation = ItemBehaviour.findStockpileAllocation(gameContext.getAreaMap(), this.parentEntity, null)) != null) {
                Job haulingJob = ItemBehaviour.createHaulingJob(tile, haulingAllocation, this.parentEntity);
                this.messageDispatcher.dispatchMessage(609, haulingJob);
            }
        }
    }

    public static ItemAllocation findStockpileAllocation(TiledMap areaMap, Entity itemEntity, Entity entityHoldingItem) {
        Room room2;
        ItemAllocation haulingAllocation = null;
        Vector2 itemPosition = itemEntity.getLocationComponent().getWorldPosition();
        if (itemPosition == null && entityHoldingItem != null) {
            itemPosition = entityHoldingItem.getLocationComponent().getWorldPosition();
        }
        TreeMap<Float, Room> stockpilesByDistance = new TreeMap<Float, Room>(Comparator.comparingInt(o -> (int)(o.floatValue() * 10.0f)));
        for (Room room2 : areaMap.getRooms().values()) {
            if (room2.getStockpileComponent() == null) continue;
            stockpilesByDistance.put(Float.valueOf(itemPosition.dst2(room2.getAvgWorldPosition())), room2);
        }
        Iterator<Room> iterator = stockpilesByDistance.values().iterator();
        while (iterator.hasNext() && (haulingAllocation = (room2 = iterator.next()).getStockpileComponent().allocate(itemEntity, areaMap)) == null) {
        }
        return haulingAllocation;
    }

    public static Job createHaulingJob(MapTile tile, ItemAllocation haulingAllocation, Entity itemEntity) {
        Job haulingJob = new Job(JobType.HAULING);
        haulingJob.setTargetEntityId(itemEntity.getId());
        haulingJob.setJobLocation(tile.getTilePosition());
        haulingJob.setItemAllocation(haulingAllocation);
        return haulingJob;
    }

    @Override
    public SteeringComponent getSteeringComponent() {
        return null;
    }

    @Override
    public boolean isUpdateEveryFrame() {
        return false;
    }

    @Override
    public boolean isUpdateInfrequently() {
        return true;
    }

    @Override
    public boolean isJobAssignable() {
        return false;
    }
}

